/**
* Script: game_worlds.js
* Written by: Radnen
* Updated: 12/24/2010
**/

function GameWorld(name, nebula, density, cap) {
	this.name = name;
	this.nebula = nebula;
	this.asteroidDensity = density;
	this.origin = {x: 0, y: 0};
	this.neighbors = [];
	this.planets = [];
	this.shipcap = cap;
	
	this.add = function(obj) {
		for (var i in obj) this[i] = obj[i];
	}
}

// World in this case means "Star System", such as Sol: //
var GameWorlds = ({});
GameWorlds.Sol = new GameWorld("Sol", "nebula_1", 25, 8);
GameWorlds.Sol.add({
	neighbors: ["Archon", "Tellus", "Bandia", "Mede"],
	planets: ["Earth", "Luna", "Mars"],
});

GameWorlds.Archon = new GameWorld("Archon", "nebula_2", 40, 6);
GameWorlds.Archon.add({
	origin: {x: 20, y: -15},
	neighbors: ["Sol", "Hades"],
	planets: ["Argay", "Carbonos"]
});

GameWorlds.Hades = new GameWorld("Hades", "nebula_2", 20, 4);
GameWorlds.Hades.add({
	origin: {x: 30, y: 30},
	neighbors: ["Archon", "Mede"],
	planets: ["Hades"],
});

GameWorlds.Mede = new GameWorld("Mede", "nebula_1", 25, 5);
GameWorlds.Mede.add({
	origin: {x: 2, y: 20},
	neighbors: ["Hades", "Sol"],
	planets: ["Platus", "Meridian"],
});

GameWorlds.Tellus = new GameWorld("Tellus", "nebula_1", 10, 5);
GameWorlds.Tellus.add({
	origin: {x: -16, y: -30},
	neighbors: ["Sol", "Bandia"],
	planets: ["Galiant", "Pinrock"],
});

GameWorlds.Bandia = new GameWorld("Bandia", "nebula_1", 20, 4);
GameWorlds.Bandia.add({
	origin: {x: -25, y: -15},
	neighbors: ["Tellus", "Sol"],
	planets: ["Guardian"],
});